@extends('layouts.master')
@section('title',__('All Movies'))
@section('breadcum')
  <div class="breadcrumbbar">
    <h4 class="page-title">{{ __('All Movies') }}</h4>
    <div class="breadcrumb-list">
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="{{url('/admin')}}" title="{{ __('Dashboard') }}">{{ __('Dashboard') }}</a></li>
          <li class="breadcrumb-item active" aria-current="page">{{ __('Movies') }}</li>
        </ol>
    </div>
  </div>
@endsection
@section('maincontent')
<div class="contentbar permissionTable"> 
  <div class="row">
    <div class="col-md-12">
          <!-- Search Form -->
         <form id="searchForm" class="mb-4">
    <div class="input-group">
        <input 
            type="text" 
            name="search" 
            id="movieSearch"
            class="form-control" 
            placeholder="Search movies..." 
        >
    </div>
</form>
      <div class="card-header movie-create-heading">
        <div class="row">
          <div class="col-lg-4 col-4">
            <h5 class="card-title">{{ __('All Movie') }} 
                 <input class="grand_selectallm ml-3" type="checkbox">
                                        {{__('Select All') }}
              </h5>
          </div>
          <div class="col-lg-8 col-8">
            @can('movies.delete')
              <button type="button" class="float-right btn btn-danger-rgba mr-2 " data-toggle="modal"
              data-target="#bulk_delete" title="{{ __('Delete Selected') }}"><i class="feather icon-trash mr-2"></i> {{ __('Delete Selected') }} </button>
            @endcan

            @if (Session::has('changed_language'))
            <a href="{{ route('tmdb_movie_translate') }}" class="float-right btn btn-warning-rgba mr-2" title="{{ __('Translate All To') }}"><i
                class="fa fa-language mr-2"></i>{{ __('Translate All To') }} {{Session::get('changed_language')}} </a>
            @endif
            <button type="button" class="float-right btn btn-success-rgba mb-2 mr-2 " data-toggle="modal"
            data-target=".bd-example-modal-lg" title="{{ __('Import Movies') }}"><i class="fa fa-file-excel-o mr-2"></i> {{ __('Import Movies') }} </button>
            @can('movies.create')
            <a href="{{route('movies.create')}}" class="float-right btn btn-primary-rgba mb-2 mr-2" title="{{ __('Add Movie') }}"><i
                class="feather icon-plus mr-2"></i>{{ __('Add Movie') }} </a>
            @endcan
            {{-- Bulk Delete Model Start --}}
            <div id="bulk_delete" class="delete-modal modal fade" role="dialog">
              <div class="modal-dialog modal-sm">
                  <!-- Modal content-->
                  <div class="modal-content">
                      <div class="modal-header">
                          <button type="button" class="close"
                              data-dismiss="modal">&times;</button>
                          <div class="delete-icon"></div>
                      </div>
                      <div class="modal-body text-center">
                          <h4 class="modal-heading">{{__('Are You Sure ?')}}</h4>
                          <p>{{__('Do you really want to delete selected item names here? This
                              process
                              cannot be undone.')}}</p>
                      </div>
                      <div class="modal-footer">
                        {!! Form::open(['method' => 'POST', 'action' => 'MovieController@bulk_delete', 'id' => 'bulk_delete_form']) !!}
                              <button type="reset" class="btn btn-secondary translate-y-3" data-dismiss="modal">{{__('No')}}</button>
                              <button type="submit" class="btn btn-primary">{{__('Yes')}}</button>
                          {!! Form::close() !!}
                      </div>
                  </div>
              </div>
            </div>
            {{-- Bulk Delete Model End --}}

            {{-- Impport Model Start --}}
            <div class="modal fade bd-example-modal-lg" tabindex="-1" role="dialog" aria-hidden="true"> 
              <div class="modal-dialog modal-lg">
                <div class="modal-content">
                  <div class="modal-header">
                      <h5 class="modal-title" id="exampleLargeModalLabel">{{__("Bulk Import Movies")}}</h5>
                      <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                      <span aria-hidden="true">&times;</span>
                      </button>
                  </div>
                  <div class="col-md-12">
                          <a href="{{ url('files/Movies.xlsx') }}" class="float-right btn btn-success-rgba mr-2 mt-4"><i
                              class="fa fa-file-excel-o mr-2"></i>{{ __('Download Example xls/csv File') }}</a>
                  </div>
        
                  <div class="card-header">
                      <h6 class="card-title">{{ __('Choose your xls/csv File :') }}</h6>
                      <form action="{{ url('/admin/import/movies') }}" method="POST" enctype="multipart/form-data">
                        @method('POST')
                        @csrf
                        <div class="form-group{{ $errors->has('file') ? ' has-error' : '' }} input-file-block col-md-12">
                          {!! Form::file('file', ['class' => 'input-file', 'id'=>'file']) !!}
                          <label for="file" class="btn btn-danger js-labelFile" data-toggle="tooltip" data-original-title="{{__('Choose your xls/csv File')}}">
                            <i class="icon fa fa-check"></i>
                            <span class="js-fileName">{{__('Choose A File')}}</span>
                          </label>
                          <small class="text-danger">{{ $errors->first('file') }}</small>
                          <button type="submit" class="float-right btn btn-danger-rgba mr-2 "><i class="feather icon-plus mr-2"></i> {{__('Import')}} </button>
                        </div>
                          
                      </form>
                  </div> 
                </div>
              </div>
            </div>
            {{-- Import Model End --}}
          </div>
        </div>
                        
      </div> 
      @if ($movies->isEmpty())
      <p class="text-center">No results found for your search.</p>
  @else
  <div id="visibleMovies">
      <div class="card-body permissionTable" >
        <section id="movies" class="movies-main-block">
          <div class="row">
            @if(isset($movies) && count($movies) > 0)
            @foreach($movies as $item)
            @php
              if($item->thumbnail != NULL){
                $content = @file_get_contents(public_path() .'/images/movies/thumbnails/' . $item->thumbnail); 
                if($content){
                  $image = public_path() .'/images/movies/thumbnails/' . $item->thumbnail;
                }else{
                  $image = Avatar::create($item->title)->toBase64();
                }
              }else{
                $image = Avatar::create($item->title)->toBase64();
              }

              $imageData = base64_encode(@file_get_contents($image));
              if($imageData){
                  $src = 'data: '.mime_content_type($image).';base64,'.$imageData;
              } 
            @endphp
            <div class="col-lg-3 col-md-6 col-sm-6 col-xs-12">
              <input class="permissioncheckbox form-check-card-input visibility-visible" form="bulk_delete_form" type="checkbox" value="{{$item->id}}" id="checkbox{{$item->id}}" name="checked[]">         
              <div class="card">
                @if($src != NULL)
                <a href="{{url('movie/detail', $item->slug)}}" target="__blank" title="{{$item->title}}"><img src="{{$src}}" class="card-img-top" alt="{{$item->title}}"></a>
                @endif
                <div class="overlay-bg"></div>
                @if(Module::has('Payperview') && Module::find('Payperview')->isEnabled())
                @if($item->ppv == 1 && $payperview->enable_payperview == 1 )  
                <div class="ppv-badge">
                  <a href="javascript:void();" class='badge badge-pill badge-success' title="{{__('PPV')}}">{{__('PPV')}}</a>
                </div>
                @endif
                @endif
                <div class="dropdown card-dropdown">
                  <a class="btn btn-round btn-outline-primary pull-right dropdown-toggle" type="button" id="dropdownMenuButton-{{$item->id}}" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" title="{{__('Settings')}}"><i class="feather icon-more-vertical-"></i></a>
                  <div class="dropdown-menu pull-right" aria-labelledby="dropdownMenuButton-{{$item->id}}">
                    @can('movies.view')
                      <a class="dropdown-item" href="{{url('movie/detail', $item->slug)}}" target="__blank" title="{{__('View')}}"><i class="feather icon-monitor mr-2"></i>{{__('View')}}</a>        
                    @endcan
                    @can('movies.edit')                                
                      <a class="dropdown-item" href="{{route('movies.edit', $item->id)}}" title="{{__('Edit')}}"><i class="feather icon-edit mr-2"></i> {{__('Edit')}}</a>     
                    @endcan
                    @can('movies.delete')                                 
                      <a type="button" class="dropdown-item" data-toggle="modal" data-target="#deleteModal{{$item->id}}" Title="{{__('Delete')}}"><i class="feather icon-trash mr-2"></i> {{__('Delete')}}</a>
                    @endcan
                      <a class="dropdown-item" href="{{route('movies.link', $item->id)}}" title="{{__('Add more links')}}"><i class="feather icon-link-2 mr-1"></i> {{__('Add more links')}}</a>
                  </div>
                </div>
                <div id="deleteModal{{$item->id}}" class="delete-modal modal fade card-dropdown-modal" role="dialog">
                  <div class="modal-dialog modal-sm">
                    <div class="modal-content">
                      <div class="modal-header">
                          <button type="button" class="close" data-dismiss="modal">×</button>
                          <div class="delete-icon"></div>
                      </div>
                      <div class="modal-body text-center">
                          <h4 class="modal-heading">{{__('Are You Sure ?')}}</h4>
                          <p>{{__('Do you really want to delete these records? This process cannot be undone.')}}</p>
                      </div>
                      <div class="modal-footer">
                        <form method="POST" action="{{route("movies.destroy", $item->id)}}">
                          @method('DELETE')
                          @csrf
                          <button type="reset" class="btn btn-secondary translate-y-3" data-dismiss="modal">{{__('No')}}</button>
                          <button type="submit" class="btn btn-primary">{{__('Yes')}}</button>
                        </form>
                      </div>
                    </div>
                  </div>
                </div>
                <div class="card-header">
                <h5 class="card-title"><a href="{{url('movie/detail', $item->slug)}}" target="__blank">{{$item->title}}</a></h5>
                </div>
                <div class="card-body">
                  <div class="card-block row">
                    <div class="col-xs-6 col-sm-6 col-md-6">
                      <h6 class="card-body-sub-heading">{{__('Year')}}</h6>
                      <p>{{isset($item->publish_year) && $item->publish_year ? $item->publish_year : '-' }}</p>
                    </div>
                    <div class="col-xs-6 col-sm-6 col-md-6">
                      <h6 class="card-body-sub-heading">{{__('Length')}}</h6>
                      <p>{{isset($item->duration) && $item->duration ? $item->duration : '-' }} Mins</p>
                    </div>                        
                  </div>
                  <div class="card-block card-block-ratings">
                    <h6 class="card-body-sub-heading">{{__('Ratings')}}</h6>
                    @php
                    $rating = ($item->rating)/2;
                    @endphp
                    
                    <div class="stars stars-example-css">
                      @for($rating = 1; $rating <= 5; $rating++) @if($rating<=$item->rating/2)
                          <i class='fa fa-star' style='color:#506FE4'></i>
                          @else
                          <i class='fa fa-star' style='color:#CCC'></i>
                          @endif
                      @endfor
                    </div>
                    <p>{{$item->rating}}/10</p>
                  </div>
                  <div class="card-block">
                    <h6 class="card-body-sub-heading">{{__('Genre')}}</h6>
                    @php
                      $genres = collect();
                        if (isset($item->genre_id)){
                          $genre_list = explode(',', $item->genre_id);
                          for ($i = 0; $i < count($genre_list); $i++) {
                            try {
                              $genre = App\Genre::find($genre_list[$i])->name;
                              $genres->push($genre);
                            } catch (Exception $e) {

                            }
                          }
                        }
                      @endphp
                    <p>
                      @if (count($genres) > 0)
                        @for($i = 0; $i < count($genres); $i++)
                          @if($i == count($genres)-1)
                          <a href="{{url('video/detail/genre_search', trim($genres[$i]))}}" target="__blank">{{$genres[$i]}}</a>
                          @else
                          <a href="{{url('video/detail/genre_search', trim($genres[$i]))}}" target="__blank"> {{$genres[$i]}},</a>
                          @endif
                          @endfor
                      @endif
                    </p>
                  </div>
                  <div class="card-block row">
                    <div class="col-xs-6 col-md-4 movie-create-heading">
                      <h6 class="card-body-sub-heading">{{__('Created By')}}</h6>
                      @php 
                      $username = App\User::find($item->created_by);
                      @endphp
                      <p>{{isset($username) && $username != NULL ? $username->name :'user deleted'}}</p>
                    </div>
                    <div class="col-xs-6 col-md-4">
                      <h6 class="card-body-sub-heading">{{__('Status')}}</h6>
                      <p class="status-btn">
                        @auth
                        @if(Auth::user()->is_assistant == 1)
                        @if($item->status == 1)
                              <a href="javascript:void();" class='badge badge-pill badge-success' title="{{__('Active')}}">{{__('Active')}}</a>
                          @else
                              <a href="javascript:void();" class='badge badge-pill badge-danger' title="{{__('De Active')}}">{{__('De Active')}}</a>
                        @endif
                        @else
                        @if($item->status == 1)
                              <a href="{{route('quick.movie.status', $item->id) }}" class='badge badge-pill badge-success'  title="{{__('Active')}}">{{__('Active')}}</a>
                          @else
                              <a href="{{route('quick.movie.status', $item->id) }}" class='badge badge-pill badge-danger'  title="{{__('De Active')}}">{{__('De Active')}}</a>
                        @endif
                        @endif
                        @endauth
                      </p>
                    </div>
                    @if($item->ppv != 1 )
                    <div class="col-xs-3 col-md-4">
                      <div class="form-group text-dark">
                          <div class="form-group make-switch">
                              <h6 class="card-body-sub-heading">{{__('Free')}}</h6>
                              <input class="custom_toggle col-md-6" type="checkbox" name="free" data-id="{{ $item->id }}" {{ $item->free == 1 ? 'checked' : '' }}>
                          </div>
                      </div>
                    </div>
                    @endif
                  </div>              
                </div>
              </div>
            </div>
            @endforeach
            <div class="col-md-12 pagination-block text-center">
              {!! $movies->appends(request()->query())->links() !!}
            </div>
            @else   
            <div class="col-md-12 text-center">
              <h5>{{__("Let's start :)")}}</h5>
              <small>{{__('Get Started by creating a movie! All of your movies will be displayed on this page.')}}</small>
            </div>
            @endif
          </div>
        </section>
      </div>
  </div>

  <div id="allMoviesContainer" style="display: none;">
    <div class="card-body permissionTable">
        <section class="movies-main-block">
            <div class="row">
                @foreach($allmovies as $item)
                @php
                if($item->thumbnail != NULL){
                  $content = @file_get_contents(public_path() .'/images/movies/thumbnails/' . $item->thumbnail); 
                  if($content){
                    $image = public_path() .'/images/movies/thumbnails/' . $item->thumbnail;
                  }else{
                    $image = Avatar::create($item->title)->toBase64();
                  }
                }else{
                  $image = Avatar::create($item->title)->toBase64();
                }
  
                $imageData = base64_encode(@file_get_contents($image));
                if($imageData){
                    $src = 'data: '.mime_content_type($image).';base64,'.$imageData;
                } 
              @endphp
              <div class="col-lg-3 col-md-6 col-sm-6 col-xs-12">
                <input class="permissioncheckbox form-check-card-input visibility-visible" form="bulk_delete_form" type="checkbox" value="{{$item->id}}" id="checkbox{{$item->id}}" name="checked[]">         
                <div class="card">
                  @if($src != NULL)
                  <a href="{{url('movie/detail', $item->slug)}}" target="__blank" title="{{$item->title}}"><img src="{{$src}}" class="card-img-top" alt="{{$item->title}}"></a>
                  @endif
                  <div class="overlay-bg"></div>
                  @if($item->ppv == 1 )
                  <div class="ppv-badge">
                    <a href="javascript:void();" class='badge badge-pill badge-success' title="{{__('PPV')}}">{{__('PPV')}}</a>
                  </div>
                  @endif
                  <div class="dropdown card-dropdown">
                    <a class="btn btn-round btn-outline-primary pull-right dropdown-toggle" type="button" id="dropdownMenuButton-{{$item->id}}" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" title="{{__('Settings')}}"><i class="feather icon-more-vertical-"></i></a>
                    <div class="dropdown-menu pull-right" aria-labelledby="dropdownMenuButton-{{$item->id}}">
                      @can('movies.view')
                        <a class="dropdown-item" href="{{url('movie/detail', $item->slug)}}" target="__blank" title="{{__('View')}}"><i class="feather icon-monitor mr-2"></i>{{__('View')}}</a>        
                      @endcan
                      @can('movies.edit')                                
                        <a class="dropdown-item" href="{{route('movies.edit', $item->id)}}" title="{{__('Edit')}}"><i class="feather icon-edit mr-2"></i> {{__('Edit')}}</a>     
                      @endcan
                      @can('movies.delete')                                 
                        <a type="button" class="dropdown-item" data-toggle="modal" data-target="#deleteModal{{$item->id}}" Title="{{__('Delete')}}"><i class="feather icon-trash mr-2"></i> {{__('Delete')}}</a>
                      @endcan
                        <a class="dropdown-item" href="{{route('movies.link', $item->id)}}" title="{{__('Add more links')}}"><i class="feather icon-link-2 mr-1"></i> {{__('Add more links')}}</a>
                    </div>
                  </div>
                  <div id="deleteModal{{$item->id}}" class="delete-modal modal fade card-dropdown-modal" role="dialog">
                    <div class="modal-dialog modal-sm">
                      <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal">×</button>
                            <div class="delete-icon"></div>
                        </div>
                        <div class="modal-body text-center">
                            <h4 class="modal-heading">{{__('Are You Sure ?')}}</h4>
                            <p>{{__('Do you really want to delete these records? This process cannot be undone.')}}</p>
                        </div>
                        <div class="modal-footer">
                          <form method="POST" action="{{route("movies.destroy", $item->id)}}">
                            @method('DELETE')
                            @csrf
                            <button type="reset" class="btn btn-secondary translate-y-3" data-dismiss="modal">{{__('No')}}</button>
                            <button type="submit" class="btn btn-primary">{{__('Yes')}}</button>
                          </form>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="card-header">
                  <h5 class="card-title"><a href="{{url('movie/detail', $item->slug)}}" target="__blank">{{$item->title}}</a></h5>
                  </div>
                  <div class="card-body">
                    <div class="card-block row">
                      <div class="col-xs-6 col-sm-6 col-md-6">
                        <h6 class="card-body-sub-heading">{{__('Year')}}</h6>
                        <p>{{isset($item->publish_year) && $item->publish_year ? $item->publish_year : '-' }}</p>
                      </div>
                      <div class="col-xs-6 col-sm-6 col-md-6">
                        <h6 class="card-body-sub-heading">{{__('Length')}}</h6>
                        <p>{{isset($item->duration) && $item->duration ? $item->duration : '-' }} Mins</p>
                      </div>                        
                    </div>
                    <div class="card-block card-block-ratings">
                      <h6 class="card-body-sub-heading">{{__('Ratings')}}</h6>
                      @php
                      $rating = ($item->rating)/2;
                      @endphp
                      
                      <div class="stars stars-example-css">
                        @for($rating = 1; $rating <= 5; $rating++) @if($rating<=$item->rating/2)
                            <i class='fa fa-star' style='color:#506FE4'></i>
                            @else
                            <i class='fa fa-star' style='color:#CCC'></i>
                            @endif
                        @endfor
                      </div>
                      <p>{{$item->rating}}/10</p>
                    </div>
                    <div class="card-block">
                      <h6 class="card-body-sub-heading">{{__('Genre')}}</h6>
                      @php
                        $genres = collect();
                          if (isset($item->genre_id)){
                            $genre_list = explode(',', $item->genre_id);
                            for ($i = 0; $i < count($genre_list); $i++) {
                              try {
                                $genre = App\Genre::find($genre_list[$i])->name;
                                $genres->push($genre);
                              } catch (Exception $e) {
  
                              }
                            }
                          }
                        @endphp
                      <p>
                        @if (count($genres) > 0)
                          @for($i = 0; $i < count($genres); $i++)
                            @if($i == count($genres)-1)
                            <a href="{{url('video/detail/genre_search', trim($genres[$i]))}}" target="__blank">{{$genres[$i]}}</a>
                            @else
                            <a href="{{url('video/detail/genre_search', trim($genres[$i]))}}" target="__blank"> {{$genres[$i]}},</a>
                            @endif
                            @endfor
                        @endif
                      </p>
                    </div>
                    <div class="card-block row">
                      <div class="col-xs-6 col-sm-6 col-md-6 movie-create-heading">
                        <h6 class="card-body-sub-heading">{{__('Created By')}}</h6>
                        @php 
                        $username = App\User::find($item->created_by);
                        @endphp
                        <p>{{isset($username) && $username != NULL ? $username->name :'user deleted'}}</p>
                      </div>
                      <div class="col-xs-6 col-md-6 col-md-6">
                        <h6 class="card-body-sub-heading">{{__('Status')}}</h6>
                        <p class="status-btn">
                          @auth
                          @if(Auth::user()->is_assistant == 1)
                          @if($item->status == 1)
                                <a href="javascript:void();" class='badge badge-pill badge-success' title="{{__('Active')}}">{{__('Active')}}</a>
                            @else
                                <a href="javascript:void();" class='badge badge-pill badge-danger' title="{{__('De Active')}}">{{__('De Active')}}</a>
                          @endif
                          @else
                          @if($item->status == 1)
                                <a href="{{route('quick.movie.status', $item->id) }}" class='badge badge-pill badge-success'  title="{{__('Active')}}">{{__('Active')}}</a>
                            @else
                                <a href="{{route('quick.movie.status', $item->id) }}" class='badge badge-pill badge-danger'  title="{{__('De Active')}}">{{__('De Active')}}</a>
                          @endif
                          @endif
                         
                          @endauth
                        </p>
                      </div>
                      <div class="col-xs-3 col-md-6">
                        <div class="form-group text-dark">
                            <div class="form-group make-switch">
                                <h5 class="bootstrap-switch-label">{{ __('Free') }}</h5>
                                <input class="custom_toggle col-md-6" type="checkbox" name="free" data-id="{{ $item->id }}" {{ $item->free == 1 ? 'checked' : '' }}>
                            </div>
                        </div>
                      </div>
                    </div>              
                  </div>
                </div>
              </div>
                @endforeach
            </div>
        </section>
    </div>
</div>


      @endif
    </div>
  </div>
</div>
</div>
@endsection 
@section('script')
<script>
  $('.custom_toggle').on('change', function () {
    const movieId = $(this).data('id');
    const freeStatus = $(this).is(':checked') ? 1 : 0; // Get the checkbox state
    const baseUrl = "{{ url('/') }}";
    const urlLike = `${baseUrl}/admin/quick/change/free/${movieId}`;
    
    $.ajax({
        url: urlLike,
        type: 'POST',
        data: { free: freeStatus }, // Pass the free value
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        success: function (response) {
            if (response.success) {
                console.log('success');
            } else {
                alert('Error: ' + response.message);
            }
        },
        error: function (xhr, status, error) {
            console.error('Error:', error);
            alert('An error occurred. Please try again.');
        }
    });
});
</script>  
<script>
$(document).ready(function() {
    // Remove form submit handler
    $('#searchForm').off('submit');

    $('#movieSearch').on('input', function() {
        const searchText = $(this).val().toLowerCase().trim();
        
        if (searchText.length > 0) {
            // Hide original movies and show filtered allmovies
            $('#visibleMovies').hide();
            $('#allMoviesContainer').show();

            // Filter movies based on all searchable content in the card
            $('#allMoviesContainer .col-lg-3').each(function() {
                // Get all searchable content from the card
                const movieTitle = $(this).find('.card-title a').text().toLowerCase();
                const movieYear = $(this).find('.card-block p:contains("Year")').next('p').text().toLowerCase();
                const movieLength = $(this).find('.card-block p:contains("Length")').next('p').text().toLowerCase();
                const movieGenres = $(this).find('.card-block p a').map(function() {
                    return $(this).text().toLowerCase();
                }).get().join(' ');
                const movieCreator = $(this).find('.movie-create-heading p').text().toLowerCase();
                
                // Combine all searchable content
                const searchableContent = `${movieTitle} ${movieYear} ${movieLength} ${movieGenres} ${movieCreator}`;
                
                // Show/hide based on search match
                if (searchableContent.includes(searchText)) {
                    $(this).show();
                } else {
                    $(this).hide();
                }
            });

            // Show no results message if needed
            const visibleMovies = $('#allMoviesContainer .col-lg-3:visible').length;
            if (visibleMovies === 0) {
                if (!$('#noResults').length) {
                    $('#allMoviesContainer .row').append(
                        '<div id="noResults" class="col-12 text-center">' +
                        '<p>No movies found matching your search.</p>' +
                        '</div>'
                    );
                }
            } else {
                $('#noResults').remove();
            }
        } else {
            // If search is empty, show original movies
            $('#allMoviesContainer').hide();
            $('#visibleMovies').show();
            $('#noResults').remove();
        }
    });
});
  </script>
<script src="{{ url('assets/js/custom/custom-barrating.js') }}"></script>
@endsection